% Function: This is the program that calculates hits using the alpha
% calculated based for a given comparison across all the potential
% consistency cutoffs

% Inputs:
% FoldChangeArray - a matrix array that lists the fold changes for each 
%    IP/Probe across all the experiments
% PValueArray - a matrix array that lists the p-values for each IP/Probe
%    across all the experiments
% PCutoffCell - a cell array with the different alpha cutoff values for the
%    each possible consistency level
% PerAgreeCell - a cell that lists the number of experiments a IP/Probe
%    combination must be significant with the associated p-value cutoff in
%    order to satisfy the criteria to be a hit
% IPProbeList - a cell array that lists the name of each IP/Probe
%    combination

% Outputs:
% SigID - a cell array with the IP/Probe identities of the consistent hits
% SigList - a cell array that contains additional cells to list the indices
%    of IP/Probes within a consistency (ie for >3/4 consistency this 
%    specifies the IP/Probes that satisfy 3/4 and 4/4 cutoffs)
% SigList - a cell array that lists the indices of IP/Probes that satisfy a
%    an overall consistency cutoff (unioning the 3/4 and 4/4 cutoffs)
% SigNumComb - a list that contains the number of significant hits for each
%    of the consistency cutoffs

function [SigID,SigList,SigListComb,SigNumComb] = ...
    SingleConsistentHits(FoldChangeArray,PValueArray,PListCell,PerAgree,...
    IPProbeList)

FC10 = FoldChangeArray > 0;
[~,N] = size(FoldChangeArray);

SigID = cell(length(PListCell),1);
SigList = cell(length(PListCell),1);
SigListComb = cell(length(PListCell),1);
SigNumComb = zeros(length(PListCell),1);

for i = 1:length(PListCell)

    for j = 1:length(PListCell{i})
        
    FCPerAgreePos = sum(FC10,2)>=PerAgree{i}(j);
    FCPerAgreePosIndex = find(FCPerAgreePos==1);
    PAgree4FCPosHits = zeros(1,length(FCPerAgreePosIndex));
    
        for alpha = 1:length(PAgree4FCPosHits)

       	FCalphaAgreeIndex = FC10(FCPerAgreePosIndex (alpha),:)==1; 	

        P_i = PValueArray(FCPerAgreePosIndex (alpha), FCalphaAgreeIndex);
	
        Pi_NumSig = P_i < PListCell{i}(j);         

            if sum(Pi_NumSig) == PerAgree{i}(j);
                        
                 PAgree4FCPosHits(alpha) = FCPerAgreePosIndex (alpha);
                
            end
            
        end

        
    PAgree4FCPosHits(PAgree4FCPosHits==0)=[];
    	
    FCPerAgreeNeg = sum(FC10,2)<= N-PerAgree{i}(j);
    FCPerAgreeNegIndex = find(FCPerAgreeNeg==1);
    PAgree4FCNegHits = zeros(1,length(FCPerAgreeNegIndex));
    
        for alpha = 1:length(PAgree4FCNegHits)

       	FCalphaAgreeIndex = FC10(FCPerAgreeNegIndex (alpha),:) == 0; 	

        P_i = PValueArray(FCPerAgreeNegIndex (alpha), FCalphaAgreeIndex);
	
        Pi_NumSig = P_i < PListCell{i}(j);         

            if sum(Pi_NumSig) >= PerAgree{i}(j);
                        
                 PAgree4FCNegHits(alpha) = FCPerAgreeNegIndex (alpha);
                
            end

        end

    PAgree4FCNegHits(PAgree4FCNegHits==0)=[];

    PAgree4FCHits = union(PAgree4FCPosHits,PAgree4FCNegHits);
    
    SigList{i}{j} = PAgree4FCHits;
    
    SigListComb{i} = union(SigListComb{i},PAgree4FCHits);
    
    SigNumComb(i) = length(SigListComb{i});
    
    SigID{i} = IPProbeList(SigListComb{i});
   
    end
    
end
